/*
 * Decompiled with CFR 0.152.
 */
package cds.allsky;

import cds.aladin.Tok;
import cds.allsky.Action;
import cds.allsky.BuilderCheckCode;
import cds.allsky.Context;
import java.io.File;

public class BuilderCheck
extends BuilderCheckCode {
    public BuilderCheck(Context context) {
        super(context);
    }

    @Override
    public Action getAction() {
        return Action.CHECK;
    }

    @Override
    protected void validateContextMore() throws Exception {
        String s = this.context.getCheckCode();
        if (s == null) {
            throw new Exception("Check codes unknown => CHECK action not available. Use CHECKCODE action to create it");
        }
    }

    @Override
    public void run() throws Exception {
        boolean rep = true;
        String hipscrc = this.context.getCheckCode();
        Tok tok = new Tok(this.format, " ,");
        while (tok.hasMoreTokens()) {
            String fmt = tok.nextToken();
            String v = Context.getCheckCode(fmt, hipscrc);
            if (v == null) {
                this.context.warning("Unknown check code for " + fmt + " tiles. No verification!");
                continue;
            }
            BuilderCheckCode.Info info = this.scanDir(new File(this.context.getOutputPath()), fmt);
            if (info.getCode().equals(v)) continue;
            this.context.error("Check code error in " + fmt + " tiles !");
            rep = false;
        }
        if (!rep) {
            throw new Exception("HiPS is not compliant to check codes");
        }
        this.context.info("HiPS compliant with check codes!");
    }
}

